<?php
/* --------------------------------------------------------------
   WithdrawalIds.php 2019-11-19
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\Interfaces;

use IteratorAggregate;
use JsonSerializable;

/**
 * Interface WithdrawalIds
 *
 * @package Gambio\Admin\Withdrawal\Interfaces
 */
interface WithdrawalIds extends IteratorAggregate, JsonSerializable
{
    /**
     * Returns internal withdrawals as array.
     *
     * @return WithdrawalId[]
     */
    public function items(): array;
}